/*****
*
* This file is part of the OMI program.
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by 
* the Free Software Foundation; either version 2, or (at your option)
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; see the file COPYING.  If not, write to
* the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*
*****/

/*  XMMS - Cross-platform multimedia player
 *  Copyright (C) 1998-1999  Peter Alm, Mikael Alm, Olle Hallnas, Thomas Nilsson and 4Front Technologies
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef __WIDGET_H__
#define	__WIDGET_H__

/*
 * Modified 03/12/99 by Guenter Bartsch for use in dvd_play (now oms)
 * Modified 09/01/00 by Guenter Bartsch for freeform user-defined skins
 */

#include <gtk/gtk.h>
#include <pthread.h>

typedef struct _Widget {
	GdkPixmap *parent;
	GdkGC *gc;
	gint x, y, width, height, visible;
	void (*button_release_cb) (GtkWidget *, GdkEventButton *, gpointer);
	void (*motion_cb) (GtkWidget *, GdkEventMotion *, gpointer);
	void (*draw) (struct _Widget *);
	gboolean redraw;
	gboolean inside;
} Widget;

int skin_widget_inside (void *widget, gint x, gint y);
void skin_widget_add (void *widget, GList **list);
void skin_widget_draw (void *widget);
void skin_widget_draw_list (GList *wlist, gboolean *redraw, gboolean force);

void handle_press_cb (GList *wlist, GtkWidget *widget, GdkEventButton *event);
void handle_release_cb (GList *wlist, GtkWidget *widget, GdkEventButton *event);
void handle_motion_cb (GList *wlist, GtkWidget *widget, GdkEventMotion *event);

void widget_list_change_pixmap (GList * wlist, GdkPixmap * pixmap);

#endif
