/*****
*
* This file is part of the OMI program.
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by 
* the Free Software Foundation; either version 2, or (at your option)
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; see the file COPYING.  If not, write to
* the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*
*****/

/*  XMMS - Cross-platform multimedia player
 *  Copyright (C) 1998-1999  Peter Alm, Mikael Alm, Olle Hallnas, Thomas Nilsson and 4Front Technologies
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * Modified 03/12/99 by Guenter Bartsch for use in dvd_play
 * Modified 09/01/00 by Guenter Bartsch for freeform user-defined skins
 */

#include "skin_widget.h"
#include "skin_button.h"

void skin_widget_add (void *widget, GList **list)
{
	(*list) = g_list_append (*list, widget);
}


int skin_widget_inside (void *p, gint x, gint y)
{
	Widget *w = (Widget *) p;

	if (x >= w->x && x < w->x + w->width 
		&& y >= w->y && y < w->y + w->height 
		&& w->visible)
		return 1;

	return 0;
}


void skin_widget_draw (void *p)
{
	Widget *w = (Widget *) p;

	w->redraw = TRUE;
}


void skin_widget_draw_list (GList * wlist, gboolean * redraw, gboolean force)
{
	GList *wl = wlist;

	g_return_if_fail(wlist != NULL);
	g_return_if_fail(redraw != NULL);

	*redraw = FALSE;

	while (wl) {
		Widget *w = (Widget *) wl->data;

		if ((w->redraw || force) && w->visible && w->draw) {
			w->draw (w);
			*redraw = TRUE;
		}
		wl = wl->next;
	}
}


void handle_press_cb (GList *wlist, GtkWidget * widget, GdkEventButton * event)
{
	GList *wl = wlist;

	g_return_if_fail(wlist != NULL);
	g_return_if_fail(widget != NULL);
	g_return_if_fail(event != NULL);

	while (wl) {
		PButton *button = (PButton *) wl->data;

		if (event->button != 1)
			continue;

		if (skin_widget_inside (&button->widget, event->x, event->y)) {
			button->mbPressed = 1;
			button->widget.inside = 1;
			skin_widget_draw (button);

			if ((button->button_press_cb) && (button->mbImmediate))
				button->button_press_cb (button->mnId, event);
		}

		wl = wl->next;
	}
}


void handle_release_cb (GList * wlist, GtkWidget * widget, GdkEventButton * event)
{
	GList *wl = wlist;

	g_return_if_fail(wlist != NULL);
	g_return_if_fail(widget != NULL);
	g_return_if_fail(event != NULL);

	while (wl) {
		if (((Widget *) wl->data)->button_release_cb)
			((Widget *) wl->data)->button_release_cb (widget, event, (Widget *) wl->data);
		wl = wl->next;
	}
}


void handle_motion_cb (GList * wlist, GtkWidget * widget, GdkEventMotion * event)
{
	GList *wl = wlist;

	g_return_if_fail(wlist != NULL);
	g_return_if_fail(widget != NULL);
	g_return_if_fail(event != NULL);

	while (wl) {
		if (((Widget *) wl->data)->motion_cb)
			((Widget *) wl->data)->motion_cb(widget, event, (Widget *) wl->data);
		wl = wl->next;
	}
}

