%{
/*
 *
 * Copyright (C) 1999  Thomas Mirlacher
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * The author may be reached as <dent@linuxvideo.org>
 *
 * Changes:
 *   Thomas Mirlacher <dent@linuxvideo.org> - December 28, 2000.
 *   - added id to each pixmap entry, which enables the use of textual
 *     representation of the item to fetch (agreed we have to search a
 *     list right now, instead of jumping directly to the index, but this
 *     is for allowing future automatic gui changes - even via the network)
 *
 */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

#include <config.h>

// for LOG
#include <oms/oms.h>

#include "skin.h"

extern int yylex ();
extern void yyerror (char *msg);
static void _add_pix2skin (int i, char *_filename);
//static void _add_pixmap (char *id, char *filename, int x, int y);
%}

%union {
	int integer;
	char *string;
}

%token T_PIXMAP T_TEXT T_BUTTON
%token FILENAME INTEGER
%%

config:		config_line
	|	config_line config
		;
		
config_line:	pixmap
	|	text
	|	button
		;

pixmap:		T_PIXMAP FILENAME 
		{
			_add_pix2skin ($<integer>1, $<string>2);
			free ($<string>2);
			skin[$<integer>1].type = T_PIXMAP;
		};

text:		T_TEXT FILENAME INTEGER INTEGER INTEGER 
		{
			_add_pix2skin ($<integer>1, $<string>2);
			free ($<string>2);

			skin[$<integer>1].x = $<integer>3;
			skin[$<integer>1].y = $<integer>4; 

			skin[$<integer>1].nMax = $<integer>5;
			skin[$<integer>1].type = T_TEXT;
		};

button:		T_BUTTON FILENAME INTEGER INTEGER
		{
			_add_pix2skin ($<integer>1, $<string>2);
			free ($<string>2);

			skin[$<integer>1].x = $<integer>3;
			skin[$<integer>1].y = $<integer>4;
			skin[$<integer>1].type = T_BUTTON;
		};
%%

extern int yyparse ();
extern FILE *yyin;


/* Unused function

static void _add_pixmap (char *id, char *filename, int x, int y)
{
}*/


static char *skindir;


int load_skin (const char *name)
{
	char *skincfg;

	skindir = (char *) malloc (strlen (SKIN_DIR) + strlen (name) + 3);
	sprintf (skindir, "%s/%s", SKIN_DIR, name);

	skincfg = (char *) malloc (strlen (skindir) + 10); // 10 = /skincfg
	sprintf (skincfg, "%s/skindata", skindir);

	LOG (LOG_DEBUG, "Opening skindir: %s...", skindir);
	LOG (LOG_DEBUG, "Opening skincfg: %s...", skincfg);

	if ((yyin = fopen (skincfg, "r")) < 0)
		return -1;
	free (skincfg);

	yyparse ();

	fclose (yyin);

	free (skindir);

	return 0;
}


#define __NEED_SKIN_KEYWORD
#include "skin_keyword.h"

static void _add_pix2skin (int i, char *_filename)
{
       	gchar filename[1024];
	GdkPixbuf *pixbuf;
   
	skin[i].id = strdup (keywords[i].name);		// FIXME: cleanup
	skin[i].index = i;

//printf ("adding entry %s\n", skin[i].id);

	snprintf (filename, 1024, "%s/%s", skindir, _filename);
 
	if ((pixbuf = gdk_pixbuf_new_from_file (filename))) {
		gdk_pixbuf_render_pixmap_and_mask (pixbuf,
			&skin[i].pixmap,
			&skin[i].mask,
			255);
		gdk_pixbuf_unref (pixbuf);
	} else {
		LOG (LOG_ERROR, "Error loading image %s", filename);
	}
}

static int button_index;

skin_t *get_skinbutton_next (void)
{
	for (; button_index <= SKIN_CLOSE; button_index++) {
//printf ("get_skinbutton: %s\n", skin[button_index].id);
		if (skin[button_index].type == T_BUTTON)
			return &skin[button_index++];
	}

        return NULL;
}

skin_t *get_skinbutton_first (void)
{
	button_index = 0;

	return get_skinbutton_next ();
}

skin_t *get_skin (char *id)
{
	int i;

//printf ("get_skin: %s\n", id);

	for (i=0; i <= SKIN_CLOSE; i++) {
//printf ("\t%s\n", skin[i].id);
		if (!skin[i].id || !id)
			continue;

		if (!strcasecmp (id, skin[i].id))
			return &skin[i];
	}

        return NULL;
}


GdkPixmap *get_skin_pixmap (char *id)
{
	skin_t *pSkin = get_skin (id);

	if (pSkin)
		return pSkin->pixmap;
	else
		return NULL;
}
