/*****
*
* This file is part of the OMI program.
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by 
* the Free Software Foundation; either version 2, or (at your option)
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; see the file COPYING.  If not, write to
* the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*
*****/


/*  Open Media System - oms
 *
 *  Copyright (C) 1999, 2000  Thomas Mirlacher, Guenter Bartsch
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include <stdio.h>
#include <string.h>

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gdk/gdkx.h>
#include <X11/Xlib.h>

#include <oms/oms.h>

#include "main.h"
#include "skin.h"
#include "skin_button.h"
#include "skin_panel.h"

extern void panel_button_cb (int nID_, GdkEventButton *pEvent_);
extern struct player_global_struct player_global;
extern GtkWidget *widget_panel;
extern GtkWidget *widget_playlist;
extern GtkWidget *widget_config;

static GdkPixmap *panel_bg     = NULL;
static GdkGC     *panel_gc;
extern GtkWidget *panel;
static gint       nPanelPX, nPanelPY;
static gint       nPanelWidth, nPanelHeight;
static gboolean   bPanel_moving = FALSE ;
static GList     *panel_wlist = NULL;
static PButton   *panel_buttons[100];


#if 0
static void _skin_panel_release (GtkWidget * widget, GdkEventButton * event, gpointer callback_data)
{
        skin_panel_draw (FALSE);
}
#endif

void skin_panel_button_set_status (gint id, gboolean bStatus)
{
	skin_button_set_status (panel_buttons[id], bStatus);
}


static void skin_string_draw (gchar *str_, skin_t *pFont_)
{
	GdkPixmap *pixmap = pFont_->pixmap;
	int nFontWidth, nFontHeight;
	int nCWidth, nCHeight;
	int i, nLen;
	int x_dest, y_dest;
    
	if (!pFont_ || !str_)
		return;

	gdk_window_get_size (pixmap,
		&nFontWidth, &nFontHeight);

	x_dest = pFont_->x;
	y_dest = pFont_->y;

// Char width/height
	nCWidth = nFontWidth / 32;
	nCHeight = nFontHeight / 3;
	nLen = strlen (str_);

	for (i=0; i<pFont_->nMax; i++) {
		int c=0;

		if ((i<nLen) && (str_[i] >= 32))
			c = str_[i]-32;

		if (c>=0) {
			int px, py;

			px = (c % 32) * nCWidth;
			py = (c / 32) * nCHeight;

			gdk_draw_pixmap (panel_bg, panel_gc, pixmap,
				px,py, x_dest, y_dest, nCWidth, nCHeight);
		}

		x_dest += nCWidth;
	}
}


static void skin_number_draw (gint n_, skin_t *pFont_)
{
	GdkPixmap *pixmap = pFont_->pixmap;
	int nFontWidth, nFontHeight;
	int nCWidth, nCHeight;
	int i;
	int x_dest, y_dest;
	int nDiv = 1;

	if (!pFont_)
		return;

	for (i=0; i<pFont_->nMax-1; i++)
		nDiv*=10;

	gdk_window_get_size (pixmap, &nFontWidth, &nFontHeight);

	x_dest = pFont_->x;
	y_dest = pFont_->y;

// Char width/height
	nCWidth = nFontWidth / 11;
	nCHeight = nFontHeight;

	while (nDiv>0) {
		int c = n_ / nDiv ;
		int px;

		px = c * nCWidth;

		gdk_draw_pixmap (panel_bg, panel_gc, pixmap,
			px, 0, x_dest, y_dest, nCWidth, nCHeight);

		x_dest += nCWidth;
		n_ %= nDiv;
		nDiv /= 10;
	}
}


static gboolean skin_inside_sensitive_widgets (gint x, gint y)
{
	GList *wl;
	Widget *widget;
    
	wl = panel_wlist;

	while (wl) {
		widget = (Widget *) wl->data;

		if (skin_widget_inside (widget, x, y))
			return TRUE;

		wl = wl->next;
	}

	return FALSE;
}


void skin_panel_press (GtkWidget * widget, GdkEventButton * event, gpointer callback_data)
{
	LOG (LOG_DEBUG, " ");

	if ((event->button == 1)
		&& (event->type == GDK_BUTTON_PRESS)
		&& !skin_inside_sensitive_widgets (event->x, event->y)) { // move panel
		gdk_window_raise(panel->window);
		gdk_pointer_grab(panel->window, FALSE, GDK_BUTTON_MOTION_MASK 
			| GDK_BUTTON_RELEASE_MASK, GDK_NONE, 
			GDK_NONE, GDK_CURRENT_TIME);

			bPanel_moving = TRUE;

			nPanelPX = event->x;
			nPanelPY = event->y;

	} else {
		LOG (LOG_DEBUG, "handle_press");
		handle_press_cb (panel_wlist, widget, event);
		skin_panel_draw (FALSE);
	}
}


void skin_panel_release (GtkWidget * widget, GdkEventButton * event, 
		   gpointer callback_data)
{
	gdk_pointer_ungrab (GDK_CURRENT_TIME);
	gdk_flush ();

	bPanel_moving = FALSE;

	handle_release_cb (panel_wlist, widget, event);

	skin_panel_draw (FALSE);
}


void skin_panel_motion(GtkWidget * widget, GdkEventMotion * event, 
		  gpointer callback_data)
{
	XEvent ev;
	gint i = 0;
  
	XSync (GDK_DISPLAY(), False);
  
	while (XCheckTypedEvent (GDK_DISPLAY(), MotionNotify, &ev)) {
		event->x = ev.xmotion.x;
		event->y = ev.xmotion.y;
		i++;
	}

	if (bPanel_moving) {
		gint mx, my, newx, newy;
		GdkModifierType modmask;

		gdk_window_get_pointer (NULL, &mx, &my, &modmask);

		newx = mx - nPanelPX;
		newy = my - nPanelPY;
		gdk_window_move(panel->window, newx, newy);
	}
  
	gdk_flush();
}


gint skin_panel_client_event (GtkWidget *w,GdkEventClient *event, gpointer data)
{
	static GdkAtom atom_rcfiles = GDK_NONE;

	if (!atom_rcfiles)
		atom_rcfiles = gdk_atom_intern("_GTK_READ_RCFILES", FALSE);

	if (event->message_type == atom_rcfiles) {	// set background
		gdk_window_set_back_pixmap (panel->window, panel_bg, 0);
		gdk_window_clear (panel->window);  
		return TRUE;
	}

	return FALSE;
}


void skin_panel_draw (gboolean force)
{
	gboolean redraw;

// Main Skin
	gdk_draw_pixmap (panel_bg,  panel_gc, get_skin_pixmap ("background"), 
		0, 0, 0, 0, nPanelWidth, nPanelHeight);
  
// =>Playlist  GetCurrentLocation (&title, &part, &timecode);
	skin_string_draw (player_global.strCurSourceName, get_skin ("source"));
	skin_number_draw (player_global.nCurChapter, get_skin ("cnum"));
	skin_string_draw (player_global.strCurChapter, get_skin ("chapter"));
	skin_number_draw (player_global.nCurTitle+1, get_skin ("tnum"));

// draw widgets
	skin_widget_draw_list (panel_wlist, &redraw, TRUE);
	gdk_window_clear (panel->window);
	gdk_flush ();
}


void skin_panel_apply ()
{
	skin_t *skin_entity;
	skin_t *button;

	skin_entity = get_skin ("background");

	gdk_window_get_size (skin_entity->pixmap, &nPanelWidth, &nPanelHeight);
	gtk_widget_set_usize (GTK_WIDGET(panel), nPanelWidth, nPanelHeight);

// set background pixmap
	panel_bg = gdk_pixmap_new (panel->window, nPanelWidth, nPanelHeight, 
				   gdk_visual_get_best_depth ());

	gdk_window_set_back_pixmap (panel->window, panel_bg, 0);
	gtk_widget_shape_combine_mask (panel, skin_entity->mask, 0, 0);

	button = get_skinbutton_first ();

	while (button) {	
		int width, height;
		int i = button->index;

		if (!(button->pixmap))
			continue;

		gdk_window_get_size (button->pixmap, &width, &height);

		width /= 3;	// 3 sub-images per image

		skin_button_change (panel_buttons[i],
			panel_bg,
			button->x, button->y,
			width, height,
			button->pixmap,
			button->mask,
			0, i);

		button = get_skinbutton_next ();
	}

	skin_panel_draw (TRUE);
}


GtkWidget *skin_panel_setup (void)
{
	skin_t *skin_entity;
	skin_t *button;

	gdk_window_set_decorations (panel->window, 0);
	gtk_window_set_policy (GTK_WINDOW (panel), FALSE, FALSE, FALSE);

//
	skin_entity = get_skin ("background");

	gdk_window_get_size (skin_entity->pixmap, &nPanelWidth, &nPanelHeight);
        gtk_widget_set_usize (GTK_WIDGET(panel), nPanelWidth, nPanelHeight);

// for setup
        panel_gc = gdk_gc_new (panel->window);
// /for setup

// set background pixmap
	panel_bg = gdk_pixmap_new (panel->window, nPanelWidth, nPanelHeight,
		gdk_visual_get_best_depth ());

	gdk_window_set_back_pixmap (panel->window, panel_bg, 0);
	gtk_widget_shape_combine_mask (panel, skin_entity->mask, 0, 0);

// for setup
	gtk_signal_connect (GTK_OBJECT(panel), "button_press_event",
		GTK_SIGNAL_FUNC(skin_panel_press), NULL);
	gtk_signal_connect (GTK_OBJECT(panel), "button_release_event",
		GTK_SIGNAL_FUNC(skin_panel_release), NULL);
	gtk_signal_connect (GTK_OBJECT(panel), "motion_notify_event",
		GTK_SIGNAL_FUNC(skin_panel_motion), NULL);
	gtk_signal_connect (GTK_OBJECT(panel), "client_event",
		GTK_SIGNAL_FUNC(skin_panel_client_event), NULL);
// /for setup

//	gdk_window_move (panel->window, 200, 0);

// setup buttons
	button = get_skinbutton_first ();

	while (button) {
		int width, height;
		int i = button->index;

		if (!(button->pixmap))
			continue;

		gdk_window_get_size (button->pixmap, &width, &height);

		width /= 3;	// 3 sub-images per image

		panel_buttons[i] = skin_button_create (&panel_wlist,
            				panel_bg,
					panel_gc,
					button->x, button->y,
					width, height,
					button->pixmap,
					button->mask,
					0,
					panel_button_cb, i);

		if ((i==SKIN_AUDIO) || (i==SKIN_SUBPIC))
                                skin_button_set_immediate (panel_buttons[i], TRUE);

		button = get_skinbutton_next ();
	}

	return panel;
}
