%{
/*
 *
 * Copyright (C) 1999  Thomas Mirlacher
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * The author may be reached as <dent@linuxvideo.org>
 *
 *------------------------------------------------------------
 *
 */


#include <string.h>
#include "y.tab.h"

#ifdef yywrap
#undef yywrap
#endif

void yyerror (char *msg);
static int check_keyword (char *string);

int yylineno = 1;

#define YY_NO_UNPUT
%}


/**
 * state definitions
 **/

%s NAME NORMAL


/**
 * pattern definitions
 **/

ws		[\t ]+
nl		\n
comment		#.*
integer		[0-9]+
filename	[a-zA-Z0-9\.\\\/_]+
keyword		[a-zA-Z0-9]+

/**
 * and now, here it comes: we're proud to present: THE RULES!
 **/

BEGIN KEY;
%%

<INITIAL>{keyword}	{	int ret;
				if ((ret = check_keyword (yytext)) >= 0) {
			  		BEGIN NAME;
					return ret;
				} else {
					printf ("ERROR (parsing skin config file): unknown identifier \"%s\"in line %d\n", yytext, yylineno);
					return -1;
				}
			}

<NAME>{filename}	{	yylval.string = strdup (yytext);
			 	BEGIN NORMAL;
			 	return FILENAME;
			}
{integer}		{	yylval.integer = atoi (yytext);
			 	return INTEGER;
			}

{comment}		;	// ignore comment
{nl}			{	BEGIN INITIAL;
			 	yylineno++;
			}

.			;	// ignore everything else
<<EOF>>			{	return 0;
			}

%%


/**
 * tell lexer to stop at end of current file
 **/

int yywrap (void) {
	return 1;
}


/**
 * out customized error function
 **/

void yyerror (char *msg)
{
	printf ("%d: %s\n", yylineno, msg);
}


/**
 * semi-dynamic check for keywords
 **/

#define __NEED_SKIN_KEYWORD
#include "skin_keyword.h"

static int check_keyword (char *string)
{
	struct keyword *ptr = keywords;

	while (ptr->name) {
		if (!strcasecmp (ptr->name, string)) {
			yylval.integer = ptr->value; 
			return ptr->type;
		} else
			ptr ++;
	}

	return -1;
}
