/*****
*
* This file is part of the OMI program.
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by 
* the Free Software Foundation; either version 2, or (at your option)
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; see the file COPYING.  If not, write to
* the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*
*****/

#include "skin.h"

#ifdef __NEED_SKIN_KEYWORD
static struct keyword {
	char *name;
	int type;
	int value;
} keywords[] = {
	{ "background",	T_PIXMAP,	SKIN_BACKGROUND,},

	{ "source",	T_TEXT,		SKIN_SOURCE,	},
	{ "chapter",	T_TEXT,		SKIN_CHAPTER,	},
	{ "tNum",	T_TEXT,		SKIN_TNUM,	},
	{ "cNum",	T_TEXT,		SKIN_CNUM,	},
	
	{ "play",	T_BUTTON,	SKIN_PLAY,	},
	{ "stop",	T_BUTTON,	SKIN_STOP,	},
	{ "pause",	T_BUTTON,	SKIN_PAUSE,	},
	
	{ "next",	T_BUTTON,	SKIN_NEXT,	},
	{ "prev",	T_BUTTON,	SKIN_PREV,	},
	{ "playlist",	T_BUTTON,	SKIN_PLAYLIST,	},
	{ "config",	T_BUTTON,	SKIN_CONFIG,	},
	{ "subpicture",	T_BUTTON,	SKIN_SUBPIC,	},
	{ "audio",	T_BUTTON,	SKIN_AUDIO,	},
	{ "eject",	T_BUTTON,	SKIN_EJECT,	},
	{ "close",	T_BUTTON,	SKIN_CLOSE,	},
	{ NULL,		0,		0,		},
};
#endif
