/*****
*
* This file is part of the OMI program.
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by 
* the Free Software Foundation; either version 2, or (at your option)
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; see the file COPYING.  If not, write to
* the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*
*****/

/*  XMMS - Cross-platform multimedia player
 *  Copyright (C) 1998-1999  Peter Alm, Mikael Alm, Olle Hallnas, Thomas Nilsson and 4Front Technologies
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * Modified 03/12/99 by Guenter Bartsch for use in oms
 * Modified 09/01/00 by Guenter Bartsch for freeform user-defined skins
 */

#ifndef PBUTTON_H
#define PBUTTON_H

#include "gtk/gtk.h"
#include "skin_widget.h"

typedef struct
{
	Widget     widget;
	GdkPixmap *pixmap;
	GdkBitmap *mask;

	gboolean   mbPressed;
	gboolean   mbHasStatus;
	gint       mnId;
	gboolean   mbStatus;
	gboolean   mbImmediate;

	void (*button_press_cb) (int nID, GdkEventButton *pEvent);
} PButton;

PButton *skin_button_create (GList ** wlist, GdkPixmap * parent, 
			GdkGC * gc, 
			gint x, gint y, gint w, gint h,
			GdkPixmap *pix,
			GdkBitmap *mask,
			gboolean bHasStatus,
			void (*cb) (int nID, GdkEventButton *pEvent), 
			gint nID);

void skin_button_change (PButton *b, 
		    GdkPixmap *parent,
		    gint x, gint y, gint w, gint h,
		    GdkPixmap *pSkin,
		    GdkBitmap *mask,
		    gboolean   bHasStatus,
		    gint nID);

void free_pbutton (PButton * b);

void skin_button_set_status (PButton *b, gboolean bStatus);
void skin_button_set_immediate (PButton *b, gboolean bImmediate);

#endif
