/*****
*
* This file is part of the OMI program.
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by 
* the Free Software Foundation; either version 2, or (at your option)
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; see the file COPYING.  If not, write to
* the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*
*****/

/*
 *
 * Copyright (C) 1999  Thomas Mirlacher Guenter Bartsch
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <gtk/gtk.h>

#include "skin_button.h"
#include "skin.h"

extern GdkPixmap * get_skin_pixmap(char *);


static void skin_button_draw (Widget *w)
{
	PButton *button = (PButton *) w;
	GdkPixmap *src;
	GdkPixmap *obj;
	int x_offset;
 
	if (!button)
		return;

	if (!(src = button->pixmap))	// dont draw a non-existing pixmap
		return;
    
	obj = button->widget.parent;

    /*
     * find out which part of the skin (=>which status of the button) to display
     */
    
	if (button->widget.inside) {
		if (button->mbPressed) {
			if (button->mbHasStatus && button->mbStatus)
				x_offset = button->widget.width * 3;
			else
				x_offset = button->widget.width;
		} else {
			if (button->mbHasStatus) {
				if (button->mbStatus)
					x_offset = button->widget.width * 5;
				else
					x_offset = button->widget.width * 3;
			} else {
				x_offset = 0;
			}
		}
	} else {
		if (button->mbStatus && button->mbHasStatus)
			x_offset = button->widget.width * 2;
		else
			x_offset = 0;
	}
   
	//gdk_gc_set_clip_mask (button->widget.gc, button->mask); 
	gdk_draw_pixmap (obj, button->widget.gc,
		src, x_offset, 0,
		button->widget.x, button->widget.y, 
		button->widget.width, button->widget.height);
}


static void skin_button_release_cb (GtkWidget * widget, GdkEventButton * event, PButton * button)
{
	if (event->button != 1)
		return;

	if (button->widget.inside && button->mbPressed) {
		button->widget.inside = 0;
		skin_widget_draw (button);

		if ((button->button_press_cb) && (!button->mbImmediate))
			button->button_press_cb (button->mnId, event);
	}

	if (button->mbPressed)
		button->mbPressed = 0;
}


static void skin_button_motion_cb (GtkWidget * widget, GdkEventMotion * event, PButton * button)
{
	int bInside;

	if (!button->mbPressed)
		return;

	bInside = skin_widget_inside (&button->widget, event->x, event->y);

	if (bInside != button->widget.inside) {
		button->widget.inside = bInside;
		skin_widget_draw (button);
	}
}


void skin_button_set_status (PButton *b, gboolean bStatus)
{
	b->mbStatus = bStatus;
	skin_widget_draw (b);
}


void skin_button_set_immediate (PButton *b, gboolean bImmediate)
{
	b->mbImmediate = bImmediate;
	skin_widget_draw (b);
}


PButton *skin_button_create (GList **wlist, GdkPixmap * parent,
			GdkGC * gc, 
			gint x, gint y, gint w, gint h,
			GdkPixmap *pix,
			GdkBitmap *mask,
			gboolean bHasStatus,
			void (*cb) (int nID, GdkEventButton *pEvent), gint nID)
{
	PButton *button;

	button = (PButton *) g_malloc0 (sizeof (PButton));

	button->widget.parent = parent;
	button->widget.gc = gc;
	button->widget.x = x;
	button->widget.y = y;
	button->widget.width = w;
	button->widget.height = h;
	button->widget.visible = 1;
	button->button_press_cb = cb;
	button->widget.button_release_cb = GTK_SIGNAL_FUNC(skin_button_release_cb);
	button->widget.motion_cb = GTK_SIGNAL_FUNC(skin_button_motion_cb);
	button->widget.draw = skin_button_draw;
	button->pixmap = pix;
	button->mask = mask;
	button->mbHasStatus = bHasStatus;
	button->mbImmediate = FALSE;
	button->mnId = nID;

	skin_widget_add (button, wlist);

	return button;
}


void skin_button_change (PButton *button, 
		    GdkPixmap *parent,
		    gint x, gint y, gint w, gint h,
		    GdkPixmap *pixmap,
		    GdkBitmap *mask,
		    gboolean   bHasStatus,
		    gint nID)
{
	button->widget.parent = parent;
	button->widget.x = x;
	button->widget.y = y;
	button->widget.width = w;
	button->widget.height = h;
	button->pixmap = pixmap;
	button->mask = mask;
	button->mbHasStatus = bHasStatus;
	button->mnId = nID;
}


void free_pbutton (PButton *button)
{
	g_free (button);
}
