/*****
*
* This file is part of the OMI program.
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by 
* the Free Software Foundation; either version 2, or (at your option)
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; see the file COPYING.  If not, write to
* the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*
*****/

#ifndef __SKIN_H__
#define __SKIN_H__

#include <gdk/gdk.h>

// tmp hack
#define NIKS_BACKGROUND "background"
#define NIKS_SOURCE	"source"
#define NIKS_CHAPTER	"chapter"
#define NIKS_TNUM	"tnum"
#define NIKS_CNUM	"cnum"
#define NIKS_PLAY	"play"
#define NIKS_STOP	"stop"
#define NIKS_PAUSE	"pause"
#define NIKS_NEXT	"next"
#define NIKS_PREV	"prev"
#define NIKS_PLAYLIST	"playlist"
#define NIKS_CONFIG	"config"
#define NIKS_SUBPIC	"subpic"
#define NIKS_AUDIO	"audio"
#define NIKS_EJECT	"eject"
#define NIKS_CLOSE	"close"
// tmp hack end

enum skin_enum {
        SKIN_BACKGROUND,
        SKIN_SOURCE, SKIN_CHAPTER, SKIN_TNUM, SKIN_CNUM,
        SKIN_PLAY, SKIN_STOP, SKIN_PAUSE,
        SKIN_NEXT, SKIN_PREV, SKIN_PLAYLIST, SKIN_CONFIG, SKIN_SUBPIC, SKIN_AUDIO, SKIN_EJECT, SKIN_CLOSE
};

typedef struct {
	char *id;	// id of entry (like "Play")
	int type;	// T_PIXMAP, T_TEXT, T_BUTTON
	int index;	// UGLY HACK - REMOVE
	GdkPixmap *pixmap;
	GdkBitmap *mask;
	int x,y;	// text and buttons only
	int nMax;	// text only
} skin_t;

skin_t skin[100];

int load_skin (const char *skinfile);

skin_t *get_skin (char *id);
GdkPixmap *get_skin_pixmap (char *id);
skin_t *get_skinbutton_first (void);
skin_t *get_skinbutton_next (void);

#endif
