/*****
*
* This file is part of the OMI program.
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by 
* the Free Software Foundation; either version 2, or (at your option)
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; see the file COPYING.  If not, write to
* the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*
*****/

#ifndef __PLAYLIST_OP_H__
#define __PLAYLIST_OP_H__

gint playlist_add_entry (gchar *type, gchar *location, gchar *title, gchar *chapter, gint titlenr, gint chapternr, gint row_number);

void playlist_drag_data_received  (GtkWidget *widget, GdkDragContext *context, gint x, gint y, GtkSelectionData *data, guint info, guint time);
void playlist_selection_made (GtkWidget *widget, gint row, gint column, GdkEventButton *event, gpointer user_data);
gint playlist_item_press (GtkWidget *widget, GdkEvent *event);

void playlist_move_up (GtkButton *button, gpointer user_data);
void playlist_move_down (GtkButton *button, gpointer user_data);
void playlist_add_file (GtkButton *button, gpointer user_data);
void playlist_remove (GtkButton *button, gpointer user_data);
void playlist_clear (GtkButton *button, gpointer user_data);
void playlist_save ();
void playlist_load ();

#endif
