/*****
*
* This file is part of the OMI program.
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by 
* the Free Software Foundation; either version 2, or (at your option)
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; see the file COPYING.  If not, write to
* the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*
*****/

/*  Open Media System - oms
 *
 * Copyright (C) 1999  Thomas Mirlacher, Guenter Bartsch
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef PLAYLIST_H
#define PLAYLIST_H

/* one navigation item */
struct omsitem_info {
	gchar *input;
	gchar *title;
	gchar *chapter;
	gint titlenr;
	gint chapternr;
};

/* the playlist structure */
typedef struct {
	GtkWidget *flatlist;
	GtkScrolledWindow *flat_scroller;
	GdkColor color_playing;
	GdkColormap *color_map;
	/* TRUE if initial setup of player_global is done */
	gboolean first_set;
	/* titleinformation currently played */	
	struct omsitem_info *current_navitem;
	/* selected row in playlist, currently playing row */	
	gint selected_row, playing_row;
	/* indicating that there's a selection in progress */
	gboolean selection_inprogress;
} playlist_global_t;

GtkWidget *setup_playlist ();
void hide_playlist () ;

gboolean playlist_play_next();
gboolean playlist_play_current();
gboolean playlist_play_prev();

#endif
