/*****
*
* This file is part of the OMI program.
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by 
* the Free Software Foundation; either version 2, or (at your option)
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; see the file COPYING.  If not, write to
* the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*
*****/

/* Open Media System - oms
 *
 * the playlist
 *
 * Copyright (C) 1999-2000  Thomas Mirlacher, Guenter Bartsch
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *  Changes:
 *    Dominik Schnitzer <dominik@schnitzer.at> - December 26, 2000.
 *    - gtk cleanups, fixes
 */


#define PL_WIDTH	320
#define PL_HEIGHT	200

#include <stdio.h>	// LOG
#include <gtk/gtk.h>
#include "playlist.h"
#include "playlist_op.h"
#include "playlist_misc.h"
#include "config_gui.h"
#include "main.h"	// player_global_struct

#include <oms/log.h>

static GtkWidget* _pl_setup_plain (void);
void hide_playlist ();

/**
 * DnD stuff
 **/

enum {
	TARGET_STRING,
	TARGET_ROOTWIN
};

static GtkTargetEntry target_table[] = {
        { "STRING",     0, TARGET_STRING },
        { "text/plain", 0, TARGET_STRING }
};
static guint n_targets = sizeof(target_table) / sizeof(target_table[0]);

extern GtkWidget *widget_playlist;
extern struct player_global_struct player_global;

/**
 * Global variables
 **/

playlist_global_t playlist_global = {
	flatlist:		NULL,
	flat_scroller:		NULL,
	color_playing:		{ 0, 0xd000, 0xd000, 0xd000 },
	color_map:		NULL,
	first_set:		FALSE,
	current_navitem:	NULL,
	selected_row:		-1,
	playing_row:		-1,
	selection_inprogress:	FALSE
};


static GtkWidget* _pl_setup_plain (void)
{
	GtkWidget *hbox;
	gchar     *strTitles[3] = { "Source", "Caption", NULL } ;

	hbox = gtk_hbox_new (FALSE, 2);

	playlist_global.flat_scroller = GTK_SCROLLED_WINDOW (gtk_scrolled_window_new (NULL, NULL));
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (playlist_global.flat_scroller),
		GTK_POLICY_AUTOMATIC,
		GTK_POLICY_AUTOMATIC);
	gtk_widget_set_usize (GTK_WIDGET (playlist_global.flat_scroller), PL_WIDTH, PL_HEIGHT);
	gtk_widget_show (GTK_WIDGET(playlist_global.flat_scroller));
  
	playlist_global.flatlist = gtk_clist_new_with_titles (2, strTitles);
	gtk_widget_show (playlist_global.flatlist);
  
	gtk_signal_connect_object (GTK_OBJECT (playlist_global.flatlist), "select_row",
		GTK_SIGNAL_FUNC(playlist_selection_made),
		NULL);
	gtk_signal_connect_object (GTK_OBJECT (playlist_global.flatlist), "button_press_event",  GTK_SIGNAL_FUNC (playlist_item_press), GTK_OBJECT(playlist_global.flatlist));
  
	gtk_container_add(GTK_CONTAINER(playlist_global.flat_scroller), playlist_global.flatlist);

	gtk_drag_dest_set (playlist_global.flatlist,
		GTK_DEST_DEFAULT_ALL,
		target_table, n_targets,
		GDK_ACTION_COPY | GDK_ACTION_MOVE);
 
	gtk_signal_connect (GTK_OBJECT(playlist_global.flatlist), "drag_data_received",
		GTK_SIGNAL_FUNC(playlist_drag_data_received), NULL);

	gtk_box_pack_start (GTK_BOX (hbox), GTK_WIDGET(playlist_global.flat_scroller), 
		TRUE, TRUE, 2);

	return hbox;
}


GtkWidget* setup_playlist ()
{
	GtkWidget *hbox, *win;
  
	win = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title (GTK_WINDOW (win), "Playlist");
	gtk_signal_connect (GTK_OBJECT(win), "delete_event", GTK_SIGNAL_FUNC (hide_playlist), NULL);

	playlist_global.color_map = gdk_colormap_get_system();
	gdk_color_alloc (playlist_global.color_map, &playlist_global.color_playing);
 
	hbox = _pl_setup_plain ();
	gtk_container_set_border_width (GTK_CONTAINER (hbox), 5);
	gtk_container_add (GTK_CONTAINER (win), hbox);

	gtk_widget_show (hbox);
	
	player_global.strCurSourceName = NULL;
	player_global.strCurChapter = NULL;

	playlist_load();
	return win;
}


void hide_playlist ()
{
	gtk_widget_hide (widget_playlist);
	player_global.bPLShowing = FALSE;
}
