/*****
*
* This file is part of the OMI program.
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by 
* the Free Software Foundation; either version 2, or (at your option)
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; see the file COPYING.  If not, write to
* the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*
*****/

#define SKIN 1

/*  Open Media System - oms
 *
 *  Copyright (C) 1999, 2000  Thomas Mirlacher, Guenter Bartsch
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <string.h>
#include <stdlib.h>

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gdk/gdkx.h>
#include <X11/Xlib.h>
#include <stdio.h>

#include <oms/oms.h>
#include <oms/buf.h>

#include "config_store.h"
#include "panel_gui.h"
#include "playlist.h"
#include "playlist_op.h"
#include "main.h"

#include "skin.h"
#include "skin_button.h"
#include "skin_panel.h"
#include "noskin_panel.h"

static void (*panel_draw) (gboolean force);
static void (*panel_press) (GtkWidget * widget, GdkEventButton * event, gpointer callback_data);
static gint (*panel_client_event) (GtkWidget *w,GdkEventClient *event, gpointer data);
static void (*button_set_status) (gint id, gboolean bStatus);

extern struct player_global_struct player_global;
extern GtkWidget *widget_panel;
extern GtkWidget *widget_playlist;
extern GtkWidget *widget_config;

GtkWidget *panel;


void panel_audio_cb (gpointer pData)
{
	omsSetFilter (BUF_AUDIO, (int) pData);
}


void panel_audio_popup (GdkEventButton *pEvent)
{
	GtkWidget *pMenu, *pMenuItem;
	nav_tree_t *audio;
	int i;

// Generate Menu items
	if (!(audio = omsGetInfo (OMS_INFO_AUDIO)))
		return;

	pMenu = gtk_menu_new ();

	for (i=0; i<audio->num; i++) {
		nav_subtree_t *sub_tree = audio->title+i;

		pMenuItem = gtk_menu_item_new_with_label (sub_tree->name);

		gtk_signal_connect_object (GTK_OBJECT (pMenuItem), "activate",
			GTK_SIGNAL_FUNC (panel_audio_cb),
			(gpointer) i);

		gtk_menu_append (GTK_MENU (pMenu), pMenuItem);
		gtk_widget_show (pMenuItem);
	}
   
//DENT: delete tree on close 
	gtk_menu_popup (GTK_MENU (pMenu), NULL, NULL, NULL, NULL,
		pEvent->button, pEvent->time);
}


void panel_subpicture_cb (gpointer pData)
{
	omsSetFilter (BUF_SUBPIC, (int) pData);
}


void panel_subpicture_popup (GdkEventButton *pEvent)
{
	GtkWidget *pMenu, *pMenuItem;
	nav_tree_t *subpic;
	int i;

    // Generate Menu items
	if (!(subpic = omsGetInfo (OMS_INFO_SUBPIC)))
		return;

	pMenu = gtk_menu_new ();

	for (i=0; i<subpic->num; i++) {
		nav_subtree_t *sub_tree = subpic->title+i;

		pMenuItem = gtk_menu_item_new_with_label (sub_tree->name);

		gtk_signal_connect_object (GTK_OBJECT (pMenuItem), "activate",
			GTK_SIGNAL_FUNC (panel_subpicture_cb),
			(gpointer) i);

		gtk_menu_append (GTK_MENU (pMenu), pMenuItem);
		gtk_widget_show (pMenuItem);
	}
   
//DENT: delete tree on close 

	gtk_menu_popup (GTK_MENU (pMenu), NULL, NULL, NULL, NULL,
		pEvent->button, pEvent->time);
}


extern config_t *cfg;

void panel_button_cb (int nID_, GdkEventButton *pEvent_)
{
	switch (nID_) {
	case SKIN_CLOSE:	// should only close panel, but for now...
		playlist_save();
		config_close(cfg);
		gtk_main_quit();
		break;
	case SKIN_EJECT:	// TODO TODO TODO
	  //ok we need to do this: check to see if its ejected, if it is just inject it
	  //if its not ejected, first check and stop playing if needed, then eject
		if(oms_get_status () == STATUS_EJECT_T)
			oms_set_status (STATUS_EJECT_F);
		else if (oms_get_status () != STATUS_STOP) {
			oms_set_status  (STATUS_STOP);
			panel_update_ui ();
		} else
			oms_set_status (STATUS_EJECT_T);

		break;
	case SKIN_PLAYLIST:	// show/hide playlist
		if (player_global.bPLShowing)
			gtk_widget_hide (widget_playlist);
		else
			gtk_widget_show (widget_playlist);
	
		player_global.bPLShowing = !player_global.bPLShowing;
		break;
	case SKIN_CONFIG:	// show/hide config dialog
		if (player_global.bConfShowing)
			gtk_widget_hide (widget_config);
		else
			gtk_widget_show (widget_config);
	
		player_global.bConfShowing = !player_global.bConfShowing;
		break;

	case SKIN_PREV:
	  playlist_play_prev();
	  break;

	case SKIN_PAUSE: 
		switch (oms_get_status ()) {
		case STATUS_PAUSE_OFF:
		case STATUS_PLAY:
			oms_set_status (STATUS_PAUSE_ON);
			panel_update_ui();
			break;
		}
		break;
	case SKIN_PLAY: {
		switch (oms_get_status ()) {
		case STATUS_FINISH:
		case STATUS_STOP:
			playlist_play_current();
			break;
		case STATUS_PAUSE_ON:
			oms_set_status (STATUS_PAUSE_OFF);
			panel_update_ui();
			break;
		}
		break;
	}
	case SKIN_STOP:
		if (oms_get_status () != STATUS_STOP) {
			oms_set_status (STATUS_STOP);
			panel_update_ui();
		}
		break;
	case SKIN_NEXT:
		playlist_play_next();
		break;
	case SKIN_AUDIO:
		panel_audio_popup (pEvent_);
		break;
	case SKIN_SUBPIC:
		panel_subpicture_popup (pEvent_);
		break;
	}
}


void panel_button_cb_oms (int nID_, GdkEventButton *pEvent_)
{
	panel_button_cb (nID_, pEvent_);
}


void panel_update_ui () 
{
	int nStatus = oms_get_status ();

	switch (nStatus) {
	case STATUS_STOP:
		button_set_status (SKIN_STOP, TRUE);
		button_set_status (SKIN_PLAY, FALSE);
		button_set_status (SKIN_PAUSE,FALSE);
		break;
	case STATUS_PAUSE:
		button_set_status (SKIN_STOP, FALSE);
		button_set_status (SKIN_PLAY, FALSE);
		button_set_status (SKIN_PAUSE,TRUE);
		break;
	case STATUS_PLAY:
		button_set_status (SKIN_STOP, FALSE);
		button_set_status (SKIN_PLAY, TRUE);
		button_set_status (SKIN_PAUSE,FALSE);
		break;
	case STATUS_EJECT_T:
	        button_set_status(SKIN_EJECT, TRUE);
		button_set_status (SKIN_PLAY, FALSE);
		button_set_status (SKIN_PAUSE,FALSE);
		break;
	default:
		LOG (LOG_WARNING, "Strange status: %d", nStatus);
	}

	panel_draw  (FALSE);
	panel_draw  (TRUE);
}


GtkWidget *panel_setup (void) 
{
        const char *cypos, *cxpos;
        int ypos, xpos;
        
// setup function calls
#ifdef SKIN
	panel_draw = skin_panel_draw;
	panel_press = skin_panel_press;
	panel_client_event = skin_panel_client_event;
	button_set_status = skin_panel_button_set_status;
#else
	panel_draw = noskin_panel_draw;
	panel_press = noskin_panel_press;
	panel_client_event = noskin_panel_client_event;
	button_set_status = noskin_panel_button_set_status;
#endif
// done setup function calls

	gdk_threads_enter ();

	panel = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_widget_set_app_paintable (panel, TRUE);
	gtk_window_set_title (GTK_WINDOW (panel), "OMS - the Open Media System");

	gtk_signal_connect (GTK_OBJECT(panel), "destroy",
		GTK_SIGNAL_FUNC (gtk_main_quit), NULL);

	gtk_widget_set_events (panel, GDK_FOCUS_CHANGE_MASK 
		| GDK_BUTTON_MOTION_MASK | GDK_BUTTON_PRESS_MASK 
		| GDK_BUTTON_RELEASE_MASK | GDK_STRUCTURE_MASK);

	gtk_widget_realize (panel);

#ifdef SKIN
	skin_panel_setup ();
#else
	noskin_panel_setup ();
#endif

        cypos = config_get(cfg, NULL, "ypos");
        if ( cypos )
                ypos = atoi(cypos);
        else
                ypos = 0;

        cxpos = config_get(cfg, NULL, "xpos");
        if ( cxpos )
                xpos = atoi(cxpos);
        else
                xpos = 0;
        
	gtk_widget_set_uposition (panel, xpos, ypos);
	gdk_threads_leave();

	return panel;
}



