/*****
*
* This file is part of the OMI program.
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by 
* the Free Software Foundation; either version 2, or (at your option)
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; see the file COPYING.  If not, write to
* the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*
*****/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <fcntl.h>
#include <sys/stat.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "noskin_panel.h"

enum noskin_enum {
        SKIN_BACKGROUND, SKIN_MASK,
        SKIN_SOURCE, SKIN_CHAPTER, SKIN_TNUM, SKIN_CNUM,
        SKIN_PLAY, SKIN_STOP, SKIN_PAUSE,
        SKIN_NEXT, SKIN_PREV, SKIN_PLAYLIST, SKIN_CONFIG, SKIN_SUBPIC, SKIN_AUDIO, SKIN_EJECT, SKIN_CLOSE
};

struct button_struct {
        gchar           name[80];
        guint           accel_key;
        guint           id;
        //func
};

struct button_struct panel_button[] = {
        {"Prev",        GDK_a,  SKIN_PREV       },
        {"Pause",       GDK_s,  SKIN_PAUSE      },
        {"Play",        GDK_d,  SKIN_PLAY       },
        {"Stop",        GDK_f,  SKIN_STOP       },
        {"Next",        GDK_g,  SKIN_NEXT       },
        {"Eject",     GDK_h,  SKIN_EJECT        },
        {"",            0,      0               },
};

struct button_struct dvd_button[] = {
        {"Config",      GDK_q,  SKIN_CONFIG     },
        {"Subtitle",    GDK_w,  SKIN_SUBPIC     },
        {"Audio",       GDK_e,  SKIN_AUDIO      },
        {"Playlist",    GDK_r,  SKIN_PLAYLIST   },
        {"Close",       GDK_t,  SKIN_CLOSE      },
        {"",            0,      0               },
};

extern GtkWidget *panel;


void noskin_panel_draw (gboolean force)
{
}


void noskin_panel_press (GtkWidget * widget, GdkEventButton * event, gpointer callback_data)
{
}


gint noskin_panel_client_event (GtkWidget *w,GdkEventClient *event, gpointer data)
{
	return 0;
}


void noskin_panel_button_set_status (gint id, gboolean bStatus)
{
}

extern void panel_button_cb_oms (int nID_, GdkEventButton *pEvent_);

static void on_button_clicked (GtkButton *b, gpointer user_data)
{
        struct button_struct *button = (struct button_struct *) user_data;

	fprintf (stderr, "buttonname: %s\n", button->name);
	panel_button_cb_oms (button->id, NULL);
}


static void _create_button (struct button_struct *button, GtkWidget *hbox, GtkAccelGroup *accel_group)
{
	int i;

	for (i=0; button[i].name[0]; i++) {
		GtkWidget *widget;

		widget = gtk_button_new_with_label (button[i].name);
		gtk_widget_show (widget);

		gtk_box_pack_start (GTK_BOX (hbox), widget, TRUE, TRUE, 0);
		gtk_signal_connect (GTK_OBJECT (widget), "clicked",
			GTK_SIGNAL_FUNC (on_button_clicked),
			(gpointer *) &button[i]);

		gtk_widget_add_accelerator (widget, "pressed", accel_group,
			button[i].accel_key, 0,
			GTK_ACCEL_VISIBLE | GTK_ACCEL_SIGNAL_VISIBLE);
	}
}


GtkWidget *noskin_panel_setup (void)
{
	GtkWidget *hbox;
	GtkWidget *vbox;
	GtkAccelGroup *accel_group;

	accel_group = gtk_accel_group_new ();

	gtk_window_set_policy (GTK_WINDOW (panel), TRUE, TRUE, TRUE);

	vbox = gtk_vbox_new (TRUE, 0);
	gtk_widget_show (vbox);
	gtk_container_add (GTK_CONTAINER (panel), vbox);

// create panel buttons
	hbox = gtk_hbox_new (TRUE, 0);
	gtk_widget_show (hbox);
	gtk_container_add (GTK_CONTAINER (vbox), hbox);
	_create_button (panel_button, hbox, accel_group);

// create additional buttons
	hbox = gtk_hbox_new (TRUE, 0);
	gtk_widget_show (hbox);
	gtk_container_add (GTK_CONTAINER (vbox), hbox);
	_create_button (dvd_button, hbox, accel_group);

	gtk_window_add_accel_group (GTK_WINDOW (panel), accel_group);

	return NULL;
}
