/*****
*
* This file is part of the OMI program.
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by 
* the Free Software Foundation; either version 2, or (at your option)
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; see the file COPYING.  If not, write to
* the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*
*****/

/* Open Media System - oms
 *
 * Copyright (C) 1999  Guenter Bartsch
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <stdarg.h>

#include "messagebox.h"

static int nResult = 0;

/* 
 * Event handlers:
 */

static void cb_mb_yesok (GtkButton *button, gpointer user_data) 
{
	nResult = MB_RES_OK;
	gtk_main_quit();
}

static void cb_mb_cancel (GtkButton *button, gpointer user_data) 
{
	nResult = MB_RES_CANCEL;
	gtk_main_quit();
}

static void cb_mb_no (GtkButton *button, gpointer user_data) 
{
	nResult = MB_RES_NO;
	gtk_main_quit();
}

/*
 * message box itself
 */
static void add_mb_button (gchar *strLabel,
                           GtkSignalFunc button_action,
                           GtkWidget *pDialog,
                           GtkWidget *pBBox,
                           gboolean bDefault)
{
	GtkWidget *button;

	button = gtk_button_new_with_label(strLabel);
	gtk_signal_connect(GTK_OBJECT(button), "clicked", 
		button_action, NULL);
	gtk_signal_connect_object(GTK_OBJECT(button), "clicked", 
		GTK_SIGNAL_FUNC(gtk_widget_destroy), 
		GTK_OBJECT(pDialog));
	gtk_box_pack_start(GTK_BOX(pBBox), button, FALSE, FALSE, 0);

	if (bDefault) {
		GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
		gtk_widget_grab_default(button);
	}

	gtk_widget_show(button);
}

gint show_message(const gchar *strTitle,
                  const gint nType,
		  const gchar *strBody,
                  ...)
{
	GtkWidget *dialog, *vbox, *label, *bbox;
        char buf[1024];
        va_list va;
        
	dialog = gtk_dialog_new();
	gtk_window_set_title(GTK_WINDOW(dialog), strTitle);
	gtk_window_set_modal(GTK_WINDOW(dialog), TRUE);
  
	vbox = gtk_vbox_new(FALSE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(vbox), 15);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), vbox, TRUE, TRUE, 0);

  /*
   * label
   */
        va_start(va, strBody);
        vsnprintf(buf, sizeof(buf), strBody, va);
        va_end(va);
        
	label = gtk_label_new(buf);
	gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 0);
	gtk_widget_show(label);
	gtk_widget_show(vbox);

  /*
   * Button box
   */

	bbox = gtk_hbutton_box_new();
	gtk_button_box_set_layout(GTK_BUTTON_BOX(bbox), GTK_BUTTONBOX_SPREAD);
	gtk_button_box_set_spacing(GTK_BUTTON_BOX(bbox), 5);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area), bbox, FALSE, FALSE, 0);

  /*
   * Buttons
   */

	switch (nType) {

        case MB_OK:
		add_mb_button ("OK", cb_mb_yesok, dialog, bbox, TRUE);
		break;

        case MB_OKCANCEL:
		add_mb_button ("OK",     cb_mb_yesok,  dialog, bbox, TRUE);
		add_mb_button ("CANCEL", cb_mb_cancel, dialog, bbox, FALSE);
		break;

        case MB_YESNO:
		add_mb_button ("YES",    cb_mb_yesok,  dialog, bbox, TRUE);
		add_mb_button ("NO"    , cb_mb_no,     dialog, bbox, FALSE);
		break;

        case MB_YESNOCANCEL:
		add_mb_button ("YES",    cb_mb_yesok,  dialog, bbox, TRUE);
		add_mb_button ("NO",     cb_mb_no,     dialog, bbox, FALSE);
		add_mb_button ("CANCEL", cb_mb_cancel, dialog, bbox, FALSE);
		break;
	}
 
	gtk_widget_show(bbox);
	gtk_widget_show(dialog);

	gtk_main();

	return nResult;
}
