/*****
*
* This file is part of the OMI program.
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by 
* the Free Software Foundation; either version 2, or (at your option)
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; see the file COPYING.  If not, write to
* the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*
*****/

#ifndef __MAIN_H__
#define __MAIN_H__

#include <oms/oms.h>

struct player_global_struct {
	gchar	*strCurSourceName;
	gchar	*strCurSource;
	gint	nCurTitle;
	gchar	*strCurChapter;
	gint	nCurChapter;
	gboolean bPLShowing;
	gboolean bConfShowing;
};

void oms_gtk_threads_enter(void);
void oms_gtk_threads_leave(void);

#define THREADSAFE(x)				\
	LOG (LOG_DEBUG, "entering THREADSAFE");\
	oms_gtk_threads_enter();		\
	x;					\
	LOG (LOG_DEBUG, "leaving THREADSAFE");	\
	oms_gtk_threads_leave()

#endif
