/*****
*
* This file is part of the OMI program.
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by 
* the Free Software Foundation; either version 2, or (at your option)
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; see the file COPYING.  If not, write to
* the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*
*****/

//#define TOAST_CMD

/*
 *
 * Copyright (C) 1999 - 2000  Thomas Mirlacher
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifdef HAVE_CONFIG_H
	#include <config.h>
#endif

#include <stdio.h> 
#include <stdlib.h> 
#include <pthread.h>
#include <gtk/gtk.h>
#include <oms/oms.h>

#include "main.h"
#include "panel_gui.h"
#include "config_gui.h"
#include "config_store.h"
#include "playlist.h"
#include "skin.h"
#include "messagebox.h" 

static volatile pthread_t threadlock_owner = (pthread_t) 0;

struct player_global_struct player_global;
GtkWidget *widget_playlist;
GtkWidget *widget_config;
config_t *cfg;

void oms_gtk_threads_enter (void)
{
	pthread_t this_thread = pthread_self ();

	if (this_thread != threadlock_owner) {
		gdk_threads_enter ();
		threadlock_owner = this_thread;
	}
}


void oms_gtk_threads_leave (void)
{
	pthread_t this_thread = pthread_self ();

	if (this_thread != threadlock_owner) {
		threadlock_owner = (pthread_t) 0;
		gdk_threads_leave ();
	}
}


static void skin_load (void) 
{
	const char *skin;

        if (!(skin = config_get(cfg, NULL, "skin")))
                skin = "some";
        
	if (load_skin (skin) < 0) {
		show_message("Skin Error", MB_OK,
			"Couldn't load skin %s, reverting to default GTK ui.",
			skin);
		return;
	}        
}

static int video_plugin_load(void) 
{
	const char *video_device, *video_plugin;

        if (!(video_plugin = config_get(cfg, NULL, "output_video_plugin")))
                return -1;

        if (!(video_device = config_get(cfg, NULL, "output_video_device")))
                return -1;
                
#ifdef TOAST_CMD
	return oms_cmd ("open_output_video", NULL, video_plugin, video_device);
#else
	return omsOpenOutputVideo (NULL, video_plugin, video_device);
#endif
}


static int audio_plugin_load(void) 
{
	const char *audio_device, *audio_plugin;

        if (!(audio_plugin = config_get(cfg, NULL, "output_audio_plugin")))
                return -1;

        if (!(audio_device = config_get(cfg, NULL, "output_audio_device")))
                return -1;
               
#ifdef TOAST_CMD
	return oms_cmd ("open_output_audio", NULL, audio_plugin, audio_device);
#else
	return omsOpenOutputAudio (NULL, audio_plugin, audio_device);
#endif
}

int main (int argc, char *argv[])
{
	GtkWidget *widget_panel;
        
#ifdef TOAST_CMD	
	return oms_cmd ("init");
#else
	if (oms_init () < 0)
		exit (-1);
#endif
        
	gtk_init (&argc, &argv);
	gdk_rgb_init ();
        
	if (!(cfg = omsConfigOpen ()))
                exit(-1);
        
	if (audio_plugin_load () < 0)
            show_message("Error loading audio plugin", MB_OK,
                         "There was an error loading default / configured audio plugins");

        if (video_plugin_load() < 0)
                show_message("Error loading video plugin", MB_OK,
                             "There was an error loading default / configured video plugins");

// do UI stuff
	player_global.bPLShowing    = FALSE;
	player_global.bConfShowing  = FALSE;

        skin_load ();

        widget_panel = panel_setup ();
	widget_config = setup_config ();
	widget_playlist = setup_playlist ();
        
	gtk_widget_show (widget_panel);
	panel_update_ui ();

	setup_config_after_init();
        
	THREADSAFE (gtk_main ());

	oms_exit ();
	  
	exit (0);
}


