/*****
*
* This file is part of the OMI program.
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by 
* the Free Software Foundation; either version 2, or (at your option)
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; see the file COPYING.  If not, write to
* the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*
*****/

/*
 * 
 *  skin selection page in configuration dialog
 *
 *  Copyright (C) 2000  Thomas Mirlacher, Guenter Bartsch
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifdef HAVE_CONFIG_H
	#include <config.h>
#endif

#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <dirent.h>

#include <oms/oms.h>

#include "config_gui.h"
#include "skin.h"
#include "messagebox.h"

static GtkWidget *skinlist;
static gint      nSelectedRow=0;

extern config_t *cfg;

extern void skin_panel_apply (void);


void cfg_skin_apply (void)
{
	gchar *str_skin = NULL; 

	gtk_clist_get_text (GTK_CLIST (skinlist), nSelectedRow, 0, &str_skin);
        
        if (str_skin) {
                config_set (cfg, NULL, "skin", str_skin);

                load_skin (str_skin);

                skin_panel_apply ();
        }
}


static void _cfg_skin_setuplist (void) 
{
        const char *skin;
	gchar *strlist[2] = { NULL, NULL } ;
	DIR *skindir;
	struct dirent *direntry;
	int i;

	gtk_clist_clear ((GtkCList *) skinlist);

	if (!(skindir = opendir (SKIN_DIR))) {
		show_message ("Error", MB_OK, "Cannot open skindir %s", SKIN_DIR);
		return;
	}

	for (i=0; (direntry = readdir (skindir)); i++) {
		if ((strcmp (direntry->d_name,".")) && (strcmp (direntry->d_name,".."))) {
			strlist[0] = direntry->d_name;
			gtk_clist_append (GTK_CLIST (skinlist), (gchar **) &strlist);

                        skin = config_get(cfg, NULL, "skin");
                        if (! skin )
                                skin = "default";
                        
			if (!strcmp (direntry->d_name, skin))
				gtk_clist_select_row (GTK_CLIST (skinlist), i, 0);
		}
	}

	closedir (skindir);
}


static void _cgf_skin_selected (GtkWidget *widget, gint row, gint column, GdkEventButton *event, gpointer data)
{
	nSelectedRow = row;
}


GtkWidget *cfg_skin_create (void)
{
	GtkWidget *vbox, *scroller ;

	nSelectedRow = -1;

	vbox = gtk_vbox_new (FALSE, 5);
	gtk_widget_show (vbox);

// the list
	scroller = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scroller),
		GTK_POLICY_AUTOMATIC,
		GTK_POLICY_AUTOMATIC);
	gtk_widget_set_usize (scroller, 150, 200);
	gtk_box_pack_start (GTK_BOX (vbox), scroller, TRUE, TRUE, 5);
	gtk_widget_show (scroller);
  
	skinlist = gtk_clist_new (1);
	gtk_widget_show (skinlist);

	gtk_signal_connect_object (GTK_OBJECT (skinlist),
		"select_row",
		GTK_SIGNAL_FUNC (_cgf_skin_selected),
		NULL);
  
	gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW (scroller), skinlist);

	_cfg_skin_setuplist ();

	return vbox;
}
