/*****
*
* This file is part of the OMI program.
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by 
* the Free Software Foundation; either version 2, or (at your option)
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; see the file COPYING.  If not, write to
* the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*
*****/

/*  Open Media System - oms
 *
 *  output device page in configuration dialog
 *
 *  Copyright (C) 2000  Thomas Mirlacher, Guenter Bartsch
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include "config_store.h"
#include <gtk/gtk.h>

#ifndef CONFIG_GUI_H
#define CONFIG_GUI_H
	GtkWidget *setup_config (void) ;
        void setup_config_after_init(void);
#endif

#ifndef CONFIG_DEVICES_H
#define CONFIG_DEVICES_H
	GtkWidget *create_devices_page (void);
	void config_device_apply (void);
	GList *get_dev_list (void);
#endif

#ifndef CONFIG_OUTPUT_H
#define CONFIG_OUTPUT_H
	GtkWidget *create_output_page (void);
	void config_output_apply (void);
#endif

#ifndef CONFIG_CODEC_H
#define CONFIG_CODEC_H
	GtkWidget *create_codec_page (void);
	void config_codec_apply (void);
#endif

#ifndef CONFIG_SKIN_H
#define CONFIG_SKIN_H
	GtkWidget *cfg_skin_create (void);
	void cfg_skin_apply (void);
#endif


#ifndef CONFIG_XML_H
#define CONFIG_XML_H
	GtkWidget *create_xml_page (void);
	void config_xml_apply (void);
#endif

#ifndef CONFIG_PLUGIN_H
#define CONFIG_PLUGIN_H
	GtkWidget *create_plugin_page (int id);
	void config_plugin_apply (void);
#endif

