/*
 *  Copyright (C) 1999-2000 Thomas Mirlacher, Guenter Bartsch
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Authors:	Thomas 'Dent' Mirlacher <dent@linuxvideo.org>
 *
 */


#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <gtk/gtk.h>

#include <oms/log.h>
#include <oms/plugin.h>

#include "config_gui.h"
#include "config_store.h"
#include "main.h"
#include "ui_xml.h"
 
extern struct player_global_struct player_global;
GtkWidget *conf_win;

static struct {
	char descr[80];
	GtkWidget *(*create_func) (void);
	void (*apply_func) (void);
} notebook_list[] = {
	{"Devices",	create_devices_page,	config_device_apply	},
	{"Skin",	cfg_skin_create,	cfg_skin_apply	        },
	{"",		NULL,			NULL			},
};


static GtkWidget *widget_config;

static void close_config (void)
{
	gtk_widget_hide(conf_win);
	player_global.bConfShowing = FALSE;
}


static void config_apply (GtkButton *button, gpointer user_data) 
{
	int i;

	for (i=0; notebook_list[i].descr[0]; i++)
		notebook_list[i].apply_func ();
        
        omsConfigApply();
        
}


static void config_ok (GtkButton *button, gpointer user_data) 
{
        config_apply(button, user_data);
        close_config();
        omsConfigOk();
}


static void config_cancel (GtkButton *button, gpointer user_data) 
{
        /*
         * Not sure we really need to re read config.
         */
	close_config ();
}


/* DENT: function below COULD look like the following xml code:
<tab value="Plugin">
  <frame value="Output">
    <radiogroup>
      <script>
        ui_fkt ("xml_pluginlist" "output_audio");
      </script>
    </radiogroup>
  </frame>

  <frame value="Video">
    <radiogroup>
      <script>
        ui_fkt ("xml_pluginlist" "output_video");
      </script>
    </radiogroup>
  </frame>
</tab>
*/

void setup_config_after_init (void) 
{        
	plugin_entry_t *entry;


	ui_xml_push_parent (widget_config);

	ui_xml_render ("tab", "Output", NULL);
	ui_xml_render ("frame", "Audio", NULL);
	ui_xml_render ("radiogroup", "Audio", NULL);

        entry = plugin_get_registered (PLUGIN_ID_OUTPUT_AUDIO);

        while (entry) {
                ui_xml_render ("radiomenu", (char *)entry->fourcc_out, "output_audio_plugin");
                entry = entry->next;
        }
	ui_xml_render ("/radiogroup", "Audio", NULL);
	ui_xml_render ("/frame", "Audio", NULL);

	ui_xml_render ("frame", "Video", NULL);
	ui_xml_render ("radiogroup", "Audio", NULL);
        entry = plugin_get_registered (PLUGIN_ID_OUTPUT_VIDEO);
        while (entry) {
		if (entry->fourcc_out != 0)
			ui_xml_render ("radiomenu", (char *)entry->fourcc_out, "output_video_plugin");
                entry = entry->next;

        }
	ui_xml_render ("/radiogroup", "Audio", NULL);
	ui_xml_render ("/frame", "Video", NULL);
	ui_xml_render ("/tab", "Output", NULL);

	ui_xml_render ("tab", "Toast", NULL);
	ui_xml_render ("colorpicker", "name", "var");
	ui_xml_render ("/tab", "Toast", NULL);

	ui_xml_pop_parent ();
}


GtkWidget* setup_config (void)
{
        int i;
	GtkWidget *button;
	GtkWidget *vbox, *hbox;

        uiRegisterConfigCb (&ui_xml_render);
        
	conf_win = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_signal_connect (GTK_OBJECT (conf_win), "delete_event",
		GTK_SIGNAL_FUNC (close_config), NULL);

	gtk_window_set_title (GTK_WINDOW (conf_win), "Configuration");
	gtk_container_set_border_width (GTK_CONTAINER (conf_win), 5);

        /*
         * vbox: notebook top, buttons bottom
         */
        vbox = gtk_vbox_new (FALSE, 5);
	gtk_container_add (GTK_CONTAINER (conf_win), vbox);


        /*
         * Create a new notebook, place the position of the tabs
         */
        widget_config = gtk_notebook_new ();
        
        gtk_notebook_set_tab_pos (GTK_NOTEBOOK (widget_config), GTK_POS_TOP);
	gtk_container_set_border_width (GTK_CONTAINER (widget_config), 5);
	gtk_box_pack_start (GTK_BOX (vbox), widget_config, TRUE, TRUE, 0);
	gtk_widget_show (widget_config);


        /*
         * create standard notebook tabs
         */
	for (i=0; notebook_list[i].descr[0]; i++) {
		GtkWidget *label = gtk_label_new (notebook_list[i].descr);

		gtk_notebook_prepend_page (GTK_NOTEBOOK (widget_config), notebook_list[i].create_func (), label);
	}
        
        /*
         * buttons
         */
	hbox = gtk_hbox_new (TRUE, 5);
	gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
	gtk_widget_show(hbox);

	button = gtk_button_new_with_label ("OK");
        gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
		GTK_SIGNAL_FUNC (config_ok),
		GTK_OBJECT (widget_config));
        gtk_box_pack_start (GTK_BOX (hbox), button, TRUE, TRUE, 0);
	gtk_widget_show (button);

	button = gtk_button_new_with_label ("Apply");
        gtk_signal_connect(GTK_OBJECT (button), "clicked",
                           GTK_SIGNAL_FUNC (config_apply), NULL);
        
        gtk_box_pack_start (GTK_BOX (hbox), button, TRUE, TRUE, 0);
	gtk_widget_show (button);

	button = gtk_button_new_with_label ("Cancel");

        gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
		GTK_SIGNAL_FUNC (config_cancel),
		GTK_OBJECT (widget_config));
        gtk_box_pack_start (GTK_BOX (hbox), button, TRUE, TRUE, 0);

        /*
         * show everything to the astonished audience
         */
        gtk_widget_show (button);
	gtk_widget_show (vbox);
  
	return conf_win;
}
