/*****
*
* This file is part of the OMI program.
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by 
* the Free Software Foundation; either version 2, or (at your option)
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; see the file COPYING.  If not, write to
* the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*
*****/

/*  Open Media System - oms
 * 
 *  devices page in configuration dialog
 *
 * Copyright (C) 1999  Thomas Mirlacher, Guenter Bartsch
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <sys/stat.h>

#include <oms/oms.h>

#include "config_gui.h"
#include "messagebox.h"

static GtkWidget *clist;
static GList *glist = NULL;
static gint nSelectedRow;
extern config_t *cfg;


static void add_device_to_clist(GtkCList *clist, char *device) 
{
        gchar *tmp[2] = { NULL, NULL };

        tmp[0] = device;
        gtk_clist_append(clist, tmp);
}


static void get_devices_config(void) 
{
        const char *devices;
	gchar *ptr, **devlist;
	int i;

        devices = config_get(cfg, NULL, "devices");
        if (devices == NULL) 
		devices = "dvd:/dev/dvd";
        
	devlist = g_strsplit(devices, ",", 0);
        
        for ( i = 0; devlist[i]; i++ ) {
                ptr = g_strdup(devlist[i]);        
                add_device_to_clist((GtkCList *) clist, ptr);
                glist = g_list_append(glist, ptr);
        }

	g_strfreev(devlist);        
}


static void selection_made(GtkWidget *widget, gint row, gint column, GdkEventButton *event, gpointer data)
{
	nSelectedRow = row;
}


static int check_device (const char *device) 
{
        int ret;
        struct stat s;

        if ((ret = stat(device, &s)) < 0) {
                show_message("Error", MB_OK, "Couldn't stat %s", device);
                return -1;
        }
        
        if ( S_ISCHR(s.st_mode) < 0 || S_ISBLK (s.st_mode) < 0 ) {
                show_message("Error", MB_OK, "%s isn't a valid block device", device);
                return -1;
        }

        return 0;
}


static void add_device(GtkWidget *entry)
{
        int ret;
        gchar buf[1024];
	gchar *device;
        
	device = gtk_entry_get_text((GtkEntry *) entry);

	if ((ret = check_device(device)) < 0)
                return;
        
        snprintf(buf, sizeof(buf), "dvd:%s", device);
        device = g_strdup(buf);

        glist = g_list_append(glist, device);
        add_device_to_clist((GtkCList *)clist, device);

        gtk_entry_set_text((GtkEntry *) entry, "");
}


static void remove_device (GtkButton *button, gpointer user_data)
{       
	if (nSelectedRow >= 0) {
                glist = g_list_remove(glist, g_list_nth_data (glist, nSelectedRow));
                gtk_clist_remove((GtkCList *) clist, nSelectedRow);
	}
}


/*
 * Public function.
 */

GList *get_dev_list(void)
{
        return glist;
}


/*
 * copy pGLdev to config manager
 */
void config_device_apply(void)
{
	gchar *str;
	GString *pdevstring;
	int i;

	pdevstring = g_string_new ("");

	for (i = 0; ((str = (gchar *) g_list_nth_data(glist, i))); i++) {
		if ( pdevstring->len > 0)
			g_string_append_c (pdevstring, ',');
		g_string_append (pdevstring, str);
	}

        config_set(cfg, NULL, "devices", pdevstring->str);
	g_string_free (pdevstring, FALSE);
}


GtkWidget *create_devices_page(void)
{

  GtkWidget *vbox, *hbox, *scroller;
  GtkWidget *entry, *button;
  
  glist = NULL;

  nSelectedRow = -1;

  vbox = gtk_vbox_new (FALSE, 5);
  gtk_widget_show (vbox);

  /*
   * the List
   */

  scroller = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW (scroller),
                                 GTK_POLICY_AUTOMATIC,
                                 GTK_POLICY_AUTOMATIC);
  gtk_widget_set_usize(scroller, 150, 200);
  gtk_box_pack_start(GTK_BOX (vbox), scroller, TRUE, TRUE, 5);
  gtk_widget_show(scroller);
  
  clist = gtk_clist_new(1);
  gtk_widget_show(clist);
  gtk_signal_connect_object(GTK_OBJECT(clist), "select_row",
                            GTK_SIGNAL_FUNC(selection_made),
                            NULL);
  
  gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scroller), clist);

  /*
   * buttons
   */
  


  hbox = gtk_hbox_new (FALSE, 5);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 5);
  gtk_widget_show(hbox);

  entry = gtk_entry_new ();
  gtk_box_pack_start(GTK_BOX(hbox), entry, TRUE, TRUE, 5);
  gtk_widget_show(entry);

  button = gtk_button_new_with_label("Add Device");
  gtk_signal_connect_object(GTK_OBJECT (button), "clicked",
                            GTK_SIGNAL_FUNC (add_device), GTK_OBJECT(entry));
  gtk_box_pack_start (GTK_BOX (hbox), button, TRUE, TRUE, 5);
  gtk_widget_show(button);

  button = gtk_button_new_with_label("Remove Device");
  gtk_signal_connect(GTK_OBJECT (button), "clicked",
                     GTK_SIGNAL_FUNC (remove_device), NULL); 
  
  gtk_box_pack_start (GTK_BOX (hbox), button, TRUE, TRUE, 5);
  gtk_widget_show(button);
  

  get_devices_config();

  return vbox;
}
